set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '10340224',
      17,
      NULL,
      '2424222',
      28.339297,
      0,
      3,
      3,
      NULL,
      4.218532,
      NULL,
      28,
      18,
      1.413813,
      NULL,
      0.835104,
      NULL,
      2,
      1,
      0,
      NULL,
      0.009469,
      1.935591,
      2,
      NULL,
      2.901343,
      0.326693,
      0,
      0,
      1.158323,
      1,
      1.815508,
      0.957486,
      0.068006,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.566177,
      3,
      1,
      0.895582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.432691,
      5.500685,
      3.041159,
      1.421505,
      1.498451,
      2.410535,
      2.137636,
      NULL,
      0,
      3.107548,
      NULL,
      3.371010,
      0.542263,
      1.963783,
      0,
      NULL,
      1,
      1.772974,
      3,
      4,
      1.578501,
      1.533314,
      0,
      2,
      NULL,
      1.489045,
      NULL,
      NULL,
      0.287386,
      NULL,
      NULL,
      0,
      NULL,
      5.466079,
      1.409146,
      2.563005,
      NULL,
      1.429914,
      NULL,
      1,
      0,
      1,
      0,
      0.559352,
      0.085908,
      0,
      0.385252,
      1.783063,
      0,
      0.682616,
      NULL,
      0.276859,
      0.762654,
      3,
      4,
      1,
      0,
      3.629555,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123609,
      1.867948,
      5.623094,
      1,
      0,
      2.654795,
      7,
      4.304865,
      NULL,
      5,
      2.034903,
      9,
      NULL,
      6,
      NULL,
      1,
      1.959882,
      NULL,
      NULL,
      1.134371,
      1.933345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859673,
      1,
      NULL,
      1,
      1,
      1.473251,
      1,
      0.116572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.934743,
      0,
      0,
      0.562241,
      1,
      2.085732,
      0,
      NULL,
      NULL,
      NULL,
      5.103407,
      NULL,
      4.952642,
      1.403018,
      0.183019,
      1,
      0.029204,
      NULL,
      NULL,
      NULL,
      0.085604,
      8.763866,
      0.932193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306696,
      NULL,
      NULL,
      1.193475,
      3,
      NULL,
      0,
      NULL,
      1.440224,
      NULL,
      2,
      NULL,
      1.082982,
      0.390228,
      NULL,
      NULL,
      1,
      1.622957,
      1.605774,
      1.518928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '33113',
      '04331',
      NULL,
      1.163790,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      6.974782,
      0,
      1.162827,
      2,
      3,
      2.318971,
      NULL,
      2,
      1);
commit;
end;
/


