set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2000',
      '43421212',
      NULL,
      79.372614,
      '1421411',
      24.224462,
      6,
      0,
      NULL,
      '140114',
      4,
      '10-29-2003',
      0.797210,
      57.116166,
      0.189721,
      NULL,
      0.869262,
      NULL,
      0.911851,
      1,
      0,
      NULL,
      1.535873,
      1.555507,
      2,
      0,
      1,
      1.587226,
      1.860435,
      1.422660,
      0.920575,
      2,
      0,
      1,
      0.457989,
      1.873424,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      3.053351,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.931309,
      1.856013,
      0,
      1.862036,
      1.009117,
      NULL,
      0,
      1.683341,
      0,
      NULL,
      NULL,
      3.715549,
      1,
      2,
      3,
      2.883317,
      1.319444,
      1.425106,
      1.056499,
      3.236078,
      1,
      2,
      5,
      1,
      2,
      1.937569,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      4.082067,
      1,
      0,
      0.911526,
      1,
      1,
      NULL,
      1,
      0.541624,
      0.711483,
      1,
      0,
      1.323000,
      1.240601,
      1.632633,
      NULL,
      1,
      2.564225,
      5,
      4.417021,
      1.270335,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517362,
      4,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5.407506,
      NULL,
      NULL,
      1.432951,
      8,
      9,
      7.259677,
      5.383932,
      2.748348,
      0.960273,
      NULL,
      NULL,
      4,
      1.077107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.099600,
      1,
      1,
      1.630285,
      NULL,
      1.613546,
      1.511885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.483728,
      NULL,
      7.601072,
      0.440948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174961,
      0.068364,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316733,
      0,
      NULL,
      0.999840,
      1,
      2,
      NULL,
      0.278810,
      NULL,
      NULL,
      1.527655,
      7,
      1.266236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267405,
      NULL,
      1.919662,
      2.047767,
      3.331525,
      0.683646,
      3,
      0.582350,
      NULL,
      0.948747,
      1.325435,
      1.695330,
      0.496500,
      0,
      0.550429,
      1,
      0,
      0,
      1.705188,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.776782,
      '00232',
      '41444',
      NULL,
      1.378239,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      2,
      NULL,
      3.982724,
      3.747792,
      6,
      3.406265,
      2.417143,
      0,
      2);
commit;
end;
/


