set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '12',
      NULL,
      16,
      NULL,
      216.076223,
      1,
      2.224305,
      2,
      '310122',
      0,
      ' 4- 1-1990',
      13,
      9,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.917633,
      NULL,
      NULL,
      0.385691,
      0,
      1.335525,
      0.686616,
      0,
      1,
      1,
      0.911676,
      NULL,
      1.724425,
      0.692705,
      0,
      NULL,
      1.956063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.871193,
      1.052751,
      0.578433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115837,
      0.768506,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931368,
      0,
      1.509352,
      0,
      0,
      1.922439,
      1.991449,
      0.361553,
      1,
      0.526959,
      0.102951,
      NULL,
      1,
      NULL,
      1.258575,
      NULL,
      0,
      1,
      1.664835,
      NULL,
      0,
      0.334588,
      NULL,
      1,
      1,
      0.454780,
      1.132723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.125682,
      0.614335,
      1,
      1.294912,
      NULL,
      0,
      0,
      7.916655,
      5,
      NULL,
      6.164440,
      1.651926,
      1.185117,
      0.231558,
      NULL,
      NULL,
      NULL,
      2.281473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750900,
      1,
      0,
      0,
      0.647581,
      1,
      0.478851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.805029,
      0,
      1,
      0.785085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.147011,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      8,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.815768,
      5.960126,
      1.160936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.006505,
      0.987079,
      NULL,
      NULL,
      0.706800,
      1.663077,
      0,
      NULL,
      2,
      1.943125,
      0,
      0.874615,
      1.116630,
      0,
      1,
      0.759407,
      0,
      1.091009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.526170,
      '02333',
      '',
      '',
      1,
      '',
      NULL,
      '',
      4,
      '4310',
      '10122',
      '',
      3,
      NULL,
      0,
      4,
      2,
      NULL,
      3.884342,
      NULL,
      3.270794);
commit;
end;
/


