set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '34444033',
      NULL,
      NULL,
      NULL,
      40,
      5,
      1.260922,
      1,
      '133012',
      0.063697,
      ' 4- 5-1991',
      38.272879,
      51.571286,
      NULL,
      NULL,
      1,
      NULL,
      1.647781,
      0.589649,
      1.007838,
      NULL,
      0,
      0,
      3,
      1.325168,
      NULL,
      1,
      1,
      1,
      1.375506,
      1,
      NULL,
      NULL,
      1.953517,
      0,
      1,
      1.071325,
      0.220156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341191,
      1.249824,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745428,
      1.515380,
      1.302907,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646368,
      0.082727,
      0,
      0.257849,
      1,
      0,
      1,
      1.011757,
      1,
      1.580374,
      1.718448,
      1,
      0.066670,
      1.919035,
      0,
      0,
      0,
      0.858751,
      1.802982,
      NULL,
      0.630464,
      0,
      1,
      0.076210,
      1.499545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702393,
      0,
      NULL,
      0,
      0,
      3.512178,
      5.347853,
      5.498338,
      3.018004,
      6.310040,
      6,
      4.879200,
      5,
      3,
      0.031736,
      2,
      0,
      NULL,
      NULL,
      4,
      0.356859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746662,
      NULL,
      NULL,
      1,
      NULL,
      0.613283,
      0.994196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.831370,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5.170763,
      1,
      1,
      1.518898,
      NULL,
      NULL,
      NULL,
      1.305378,
      0.729702,
      0.225848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.439457,
      0.652360,
      0,
      2,
      3,
      0,
      1.972072,
      1,
      3.707816,
      NULL,
      0.703456,
      NULL,
      1,
      NULL,
      1,
      1,
      1.946890,
      NULL,
      1.978778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.539689,
      '32403',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      3,
      '14314',
      '01211',
      '',
      3,
      3,
      1.265535,
      5,
      4.740195,
      NULL,
      1.121227,
      5.849537,
      0);
commit;
end;
/


