set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '13441120',
      67.360753,
      NULL,
      '3113100',
      151,
      6,
      0,
      2,
      NULL,
      NULL,
      ' 4-11-1994',
      18,
      NULL,
      1,
      NULL,
      1.859658,
      NULL,
      NULL,
      0,
      1.171161,
      1.442516,
      0,
      1,
      NULL,
      1.944947,
      1,
      0.823551,
      NULL,
      1,
      1.860381,
      NULL,
      1.930350,
      1,
      1,
      0,
      0,
      0.484923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.069985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.209314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999599,
      0,
      0,
      1,
      0.450229,
      0.266795,
      0,
      0.289607,
      1,
      1.160660,
      0,
      0,
      0.082186,
      1.950812,
      0.257007,
      1.569746,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      0,
      4.658830,
      NULL,
      NULL,
      0.867369,
      NULL,
      1.360844,
      NULL,
      1,
      2,
      1.306751,
      1.957179,
      7.326602,
      1.707785,
      7,
      1.427288,
      1.298716,
      2,
      6.401186,
      NULL,
      0,
      2.740414,
      3.894168,
      1,
      NULL,
      NULL,
      5,
      1.205990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.838630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.712971,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859409,
      0.146125,
      1.184090,
      NULL,
      NULL,
      NULL,
      1.590826,
      3,
      4,
      7,
      5.391405,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.909092,
      6.740854,
      2,
      3.837258,
      NULL,
      0.796868,
      4,
      1,
      1.892634,
      1.717420,
      NULL,
      1,
      NULL,
      3.220939,
      2.029620,
      1.412535,
      2.860035,
      NULL,
      2.241998,
      1,
      1.379545,
      1,
      1,
      NULL,
      0.483287,
      1.698635,
      NULL,
      NULL,
      1.446846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.814893,
      '13314',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.455905,
      3,
      3.332818,
      1.193825,
      2.605515,
      1,
      1.652209,
      3,
      NULL);
commit;
end;
/


