set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3312',
      '12144212',
      15,
      44.798752,
      '2123113',
      240.870333,
      2,
      NULL,
      2,
      '113130',
      3,
      ' 8-11-1981',
      15,
      NULL,
      0,
      NULL,
      0.865812,
      0,
      0,
      1,
      0.937761,
      NULL,
      NULL,
      1.361636,
      3.090067,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.740550,
      1,
      3.402670,
      1,
      1.875576,
      0,
      1.190672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.544584,
      1.874330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934451,
      NULL,
      0.693008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.475453,
      NULL,
      0.290633,
      1.542861,
      1.358310,
      0.143098,
      0,
      0,
      1,
      0.413958,
      1.188087,
      1.930192,
      1,
      1,
      0,
      1.334952,
      1,
      NULL,
      NULL,
      0.717594,
      1.737657,
      1,
      NULL,
      0,
      5,
      1.516193,
      3.963031,
      0,
      NULL,
      1.297343,
      NULL,
      1,
      0,
      1.101868,
      1,
      NULL,
      NULL,
      9,
      8.733069,
      0,
      NULL,
      NULL,
      6,
      4,
      3.208051,
      0.136065,
      NULL,
      NULL,
      NULL,
      4.488631,
      1.607844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218561,
      0.839123,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.627928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759818,
      NULL,
      1.908128,
      2,
      NULL,
      2,
      1,
      2,
      1,
      0,
      NULL,
      5,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.922775,
      0.666545,
      0,
      1,
      5.973130,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414654,
      NULL,
      1,
      0,
      NULL,
      0,
      3.259024,
      3.217109,
      0.199737,
      2.185371,
      0.918957,
      NULL,
      1,
      1,
      1,
      0,
      0.306058,
      1,
      NULL,
      1.254074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.044340,
      '31220',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      5,
      '3210',
      '2103',
      NULL,
      0.658836,
      4,
      2,
      NULL,
      3,
      2,
      1,
      1,
      NULL);
commit;
end;
/


