set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8822708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4204',
      NULL,
      NULL,
      9.377577,
      '3424301',
      197,
      1,
      2,
      2,
      '001210',
      3.047112,
      ' 2-27-1980',
      9.929084,
      60,
      0.220491,
      NULL,
      0.048900,
      0.257269,
      NULL,
      1,
      1.706039,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.834247,
      0.129327,
      NULL,
      1.071892,
      1,
      0,
      0.877471,
      1.652800,
      1.261555,
      1,
      1.150685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382465,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.829723,
      1.556686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.624446,
      NULL,
      1.878368,
      NULL,
      0.103100,
      1.520546,
      0.210282,
      0,
      1,
      1.265704,
      0.943279,
      1.079002,
      1.567963,
      NULL,
      NULL,
      0.823174,
      NULL,
      NULL,
      NULL,
      0.032555,
      4,
      1.745342,
      0.026968,
      0,
      1.664631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.627418,
      NULL,
      4,
      0.510223,
      1.321383,
      2,
      NULL,
      2,
      0,
      6.737047,
      1.903201,
      5,
      5,
      2,
      5.810118,
      5,
      0.541576,
      NULL,
      NULL,
      5.965705,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485058,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.168453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.088415,
      1,
      0,
      0,
      2,
      3.235624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982642,
      0,
      0.507262,
      2.224574,
      0,
      1,
      1.102733,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.388196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.016787,
      0,
      1.083609,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.086975,
      '31314',
      NULL,
      NULL,
      0.965934,
      '',
      '',
      '',
      3,
      '4203',
      NULL,
      '',
      2.650473,
      0,
      3,
      1.796602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


