set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9986186';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '30132414',
      69.800263,
      63,
      '3323422',
      9.607734,
      4,
      1.064848,
      NULL,
      '041143',
      5,
      '10-16-1984',
      NULL,
      24.988383,
      NULL,
      NULL,
      0.339380,
      0.267995,
      0.533746,
      1,
      0.871799,
      0.555500,
      NULL,
      1.886414,
      0.955462,
      0,
      1.361097,
      0,
      1.414397,
      0,
      NULL,
      1.304692,
      1.377551,
      1,
      1.428849,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754308,
      0,
      0.869288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751104,
      NULL,
      NULL,
      1.544226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616743,
      1,
      NULL,
      1,
      1,
      1.234210,
      0,
      1,
      0.390047,
      NULL,
      0,
      1.362546,
      NULL,
      1,
      0.971109,
      1.781932,
      1,
      1,
      NULL,
      0,
      1.522441,
      0.208167,
      0.606162,
      0,
      0,
      0,
      1.499715,
      0,
      0,
      1.056124,
      1,
      1.714361,
      1,
      1,
      1.170461,
      0,
      7.039367,
      4,
      7,
      NULL,
      3.183689,
      NULL,
      4.048564,
      1,
      1,
      0.955342,
      3.664232,
      0,
      NULL,
      NULL,
      9.752680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351784,
      NULL,
      1,
      0,
      0.115166,
      1,
      0.795605,
      0.421702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583859,
      NULL,
      NULL,
      NULL,
      NULL,
      3.610557,
      3,
      0.819736,
      0.392372,
      0.808162,
      0.814100,
      7,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.187615,
      0,
      0,
      4.818659,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717548,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112096,
      0.435444,
      0,
      2,
      3,
      0,
      0.891642,
      0,
      0,
      0.769067,
      1.617310,
      0.559216,
      1,
      1,
      0,
      NULL,
      0,
      0.757489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '',
      '',
      1.309878,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      2,
      1,
      1,
      3.561338,
      1,
      0,
      NULL,
      3);
commit;
end;
/


