set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '3214210',
      9.045030,
      3,
      0.082555,
      3,
      '044031',
      2,
      ' 8-16-1980',
      13,
      NULL,
      NULL,
      NULL,
      0.634992,
      NULL,
      NULL,
      0.525817,
      0.916854,
      0.837709,
      3.178997,
      NULL,
      1,
      0,
      NULL,
      1.211794,
      NULL,
      0.865605,
      0,
      0.447700,
      0,
      NULL,
      1.912581,
      1,
      NULL,
      1,
      4.399327,
      1,
      4,
      1,
      NULL,
      1.384351,
      NULL,
      NULL,
      1.666341,
      NULL,
      NULL,
      0.724534,
      0,
      1,
      3.077250,
      1.383505,
      NULL,
      1.178908,
      NULL,
      0.754041,
      0.882021,
      1.325641,
      1,
      1.336946,
      0,
      0.369757,
      0,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472948,
      1.188085,
      1,
      1.421742,
      1.134859,
      0,
      0.828804,
      0,
      0,
      1,
      0.174653,
      0.156082,
      1,
      1.557375,
      1,
      1.753958,
      1,
      0.483407,
      1,
      NULL,
      0.629276,
      2.745318,
      1.205964,
      NULL,
      5,
      1.548376,
      2,
      NULL,
      0,
      3.222747,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      1.008130,
      NULL,
      9,
      6.080211,
      8.308888,
      0,
      2,
      8,
      6,
      1,
      NULL,
      4.004418,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1.471358,
      0,
      1.190088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782377,
      3.650921,
      NULL,
      1.114491,
      1.806894,
      0,
      0.893980,
      0.171916,
      0.132006,
      NULL,
      NULL,
      NULL,
      4.349614,
      0.000286,
      2,
      3,
      NULL,
      0,
      4,
      1.179307,
      NULL,
      NULL,
      NULL,
      2.108139,
      1.682674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504172,
      0,
      3.388511,
      1,
      3,
      3,
      3,
      1,
      1,
      NULL,
      0.941694,
      0.990337,
      1.843461,
      0.061946,
      NULL,
      0,
      0.294625,
      0.056741,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1.959220,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


