set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '0432314',
      19.321733,
      0,
      NULL,
      2,
      NULL,
      1,
      ' 2-27-1992',
      26,
      NULL,
      NULL,
      NULL,
      0.497894,
      0.728814,
      NULL,
      0,
      NULL,
      1.013802,
      2.194745,
      0.111796,
      0,
      0,
      2.243055,
      0,
      3,
      0.251886,
      NULL,
      0.374060,
      5.496503,
      1,
      NULL,
      0.600200,
      1,
      0.415951,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.325716,
      NULL,
      NULL,
      1.792634,
      NULL,
      NULL,
      6,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1.259714,
      2.319166,
      0,
      0.296799,
      1,
      3.490157,
      1.372919,
      0,
      1.538791,
      2,
      1.744955,
      NULL,
      1.348246,
      0,
      0.805219,
      1.585681,
      3.462959,
      1,
      1,
      1.788680,
      1.394151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275490,
      0.906421,
      0.129268,
      0,
      1.547096,
      NULL,
      1.584003,
      1,
      1,
      1.656293,
      0,
      0,
      0.701962,
      1.387892,
      1,
      0.770501,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126159,
      2,
      NULL,
      NULL,
      2.582418,
      0.849325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355364,
      1,
      0.270875,
      0,
      NULL,
      NULL,
      NULL,
      8,
      6,
      6.615346,
      NULL,
      3,
      6,
      1,
      1.912155,
      0.491844,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.523937,
      0,
      0,
      0.795990,
      1.293559,
      1,
      1.160865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.777151,
      3.559673,
      1.419075,
      NULL,
      NULL,
      5.932799,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.297199,
      3.706793,
      5,
      0.177540,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.787296,
      5,
      1.458956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280344,
      1.004349,
      3,
      1.541251,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      1.420894,
      1,
      0.053230,
      1,
      NULL,
      1,
      0.034327,
      0,
      0.874144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20332',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.792183,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


