set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '1144222',
      16.535876,
      0,
      3,
      0,
      '040022',
      2,
      ' 9- 4-1996',
      36,
      NULL,
      NULL,
      NULL,
      1.608500,
      0.612645,
      1.665240,
      0,
      NULL,
      NULL,
      1.597717,
      1.139979,
      0.571342,
      NULL,
      1.014191,
      0.711957,
      1,
      0,
      0.131348,
      NULL,
      0.337959,
      1.164269,
      1,
      1.949168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406790,
      0.040693,
      1.886597,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.268766,
      0.199922,
      0,
      1.379884,
      1.415990,
      NULL,
      3.254293,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      2.022578,
      NULL,
      1,
      1,
      1.582518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1.162327,
      1.785725,
      0.707623,
      NULL,
      NULL,
      1.072313,
      1,
      NULL,
      0,
      1.790694,
      1,
      1.957493,
      0,
      NULL,
      0,
      0.915643,
      0.784622,
      0,
      NULL,
      1.790523,
      0,
      NULL,
      4.338303,
      1,
      1.656655,
      NULL,
      NULL,
      0,
      1.809638,
      0.380247,
      NULL,
      3,
      4.415236,
      3.371966,
      0.213299,
      3.758642,
      6.713102,
      1,
      4.551456,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3.339412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832474,
      1,
      1,
      NULL,
      1.212980,
      NULL,
      0.245012,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.602519,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.722746,
      0.205031,
      0,
      0,
      0.178966,
      NULL,
      NULL,
      NULL,
      0,
      2.089340,
      0.825830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.282528,
      3,
      NULL,
      NULL,
      0.905781,
      2.718253,
      0,
      1,
      1.828676,
      NULL,
      0.818151,
      0,
      1,
      0.871736,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '42234',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


