set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31',
      NULL,
      4.962200,
      '4422104',
      74.317912,
      6,
      1,
      NULL,
      '332413',
      1,
      ' 4-24-1997',
      26,
      31,
      0.568209,
      NULL,
      0,
      2.978702,
      0,
      1,
      NULL,
      1,
      0.913003,
      1,
      0,
      1.232657,
      0.315462,
      1.224901,
      1,
      0.989510,
      NULL,
      1,
      5,
      0,
      5,
      0.894580,
      3.273863,
      0.850166,
      3,
      1,
      0.585116,
      1,
      1.108076,
      1.677868,
      NULL,
      NULL,
      1.429249,
      NULL,
      NULL,
      2.206638,
      0.891084,
      4.415451,
      2,
      NULL,
      0,
      3,
      1.105066,
      1.254800,
      0.160602,
      0.986961,
      0.743985,
      1.841490,
      NULL,
      0.765117,
      1.082806,
      NULL,
      1.232009,
      NULL,
      0.412024,
      1,
      NULL,
      2.742665,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.331771,
      NULL,
      NULL,
      NULL,
      0.341736,
      1,
      1,
      0,
      0.710238,
      NULL,
      1,
      0,
      0,
      NULL,
      1.828232,
      0.989793,
      0,
      NULL,
      0,
      1.664213,
      1,
      NULL,
      NULL,
      1.905115,
      0.061826,
      NULL,
      1,
      1,
      NULL,
      0.809622,
      1.799416,
      0,
      NULL,
      NULL,
      NULL,
      1.432056,
      0,
      NULL,
      0,
      0,
      0,
      1.930269,
      NULL,
      3,
      5,
      4,
      3.795054,
      5.724817,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      9.468418,
      0.160590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.806502,
      0.649701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529369,
      0.734942,
      3,
      1,
      0.095679,
      NULL,
      1.839625,
      2.454053,
      3.199211,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149186,
      NULL,
      0.644870,
      4.878870,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.664647,
      0,
      0,
      1.799779,
      0,
      NULL,
      NULL,
      1.327725,
      0.434831,
      0,
      1,
      NULL,
      0.308502,
      1.232249,
      0,
      0.625737,
      0.424199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.290296,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


