set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '01',
      9,
      8.470479,
      NULL,
      23,
      NULL,
      2,
      1,
      '334434',
      5,
      ' 9-16-1991',
      10.563031,
      23,
      0,
      NULL,
      0.640322,
      NULL,
      0,
      1.165874,
      0,
      1,
      2,
      1,
      1,
      0.241148,
      5.631978,
      0,
      1.873389,
      1,
      0,
      1,
      1.085682,
      1.862637,
      1,
      0,
      1,
      0,
      1,
      0,
      2.876061,
      0.535739,
      0.637524,
      NULL,
      NULL,
      NULL,
      0.560237,
      NULL,
      NULL,
      7.932419,
      NULL,
      0,
      2,
      0.672507,
      0.335598,
      3,
      0.326072,
      NULL,
      2,
      0,
      1.870119,
      1,
      0,
      NULL,
      NULL,
      0.570393,
      NULL,
      NULL,
      1,
      1,
      1.652179,
      5,
      1,
      0,
      1.931259,
      0.017226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.688300,
      1.025946,
      0,
      1.886871,
      1,
      1.478723,
      0.707275,
      0,
      0,
      0,
      0,
      1.229844,
      0.959381,
      0.902054,
      NULL,
      1,
      0.453341,
      0.978142,
      0,
      NULL,
      NULL,
      1.176936,
      1,
      NULL,
      1,
      1,
      0,
      0.784662,
      NULL,
      3.679965,
      NULL,
      NULL,
      0.138759,
      0.660000,
      4.227084,
      1,
      NULL,
      0.954254,
      2.419532,
      4.173782,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.910225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.033774,
      0.715288,
      NULL,
      1.169756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806145,
      0.761761,
      3.559694,
      5.179107,
      0,
      1,
      5.117804,
      NULL,
      NULL,
      NULL,
      0.626659,
      0.126704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.440009,
      2.736540,
      0.466901,
      0.030783,
      0.133777,
      0,
      1.041633,
      1.389713,
      1.533968,
      0,
      1,
      1.595749,
      0.419319,
      0,
      0,
      0.800323,
      1.647017,
      1.037433,
      0.317888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '01221',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


