set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '10',
      21.835136,
      9,
      '0002213',
      51,
      NULL,
      2,
      3,
      '423324',
      NULL,
      ' 8- 3-1993',
      6.725852,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      0.077201,
      0,
      NULL,
      1.961132,
      NULL,
      1.608358,
      NULL,
      1,
      0.362713,
      1,
      NULL,
      1,
      2,
      1,
      1.012010,
      0.039743,
      0,
      0,
      2,
      1,
      4.518769,
      3.611972,
      NULL,
      1.775953,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2.124101,
      0.129476,
      0.664402,
      0.241997,
      1.312668,
      1,
      0,
      2.271986,
      1,
      NULL,
      2.444599,
      0,
      1,
      1.505146,
      1.991211,
      0.025072,
      1,
      NULL,
      1,
      4.261706,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.485423,
      1.793576,
      1,
      NULL,
      1.171466,
      NULL,
      0,
      0.119732,
      1.677051,
      1,
      0,
      1.164174,
      1.966225,
      0.322480,
      0,
      0,
      NULL,
      NULL,
      1.310006,
      NULL,
      1.991820,
      NULL,
      1.186170,
      1.949143,
      0.681827,
      NULL,
      NULL,
      1,
      5.207836,
      1,
      NULL,
      0,
      0,
      NULL,
      2.152634,
      0,
      5,
      4,
      5.051905,
      1,
      NULL,
      5.151353,
      4.423483,
      1,
      1.927462,
      0.630474,
      1,
      2.815113,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.984855,
      0,
      NULL,
      0.460313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.505172,
      3.171785,
      3,
      1.690099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.404528,
      0.791258,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.389875,
      6.631975,
      2,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      3.017255,
      7,
      1,
      0,
      5,
      0.812068,
      2.072235,
      2,
      0,
      NULL,
      2.092250,
      NULL,
      1,
      1,
      0,
      2.484753,
      2.811919,
      0,
      1.214948,
      2,
      NULL,
      NULL,
      1,
      0.671505,
      NULL,
      0,
      1.619329,
      1,
      1.353187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '42314',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2.198979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


