set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '03',
      35.002039,
      21,
      NULL,
      118.491873,
      5,
      0,
      NULL,
      '343030',
      4.552578,
      NULL,
      5,
      23,
      0.441993,
      NULL,
      0.655468,
      1,
      1,
      1,
      1.334307,
      1.121526,
      2,
      NULL,
      0.696787,
      1,
      2,
      0,
      NULL,
      NULL,
      0.367814,
      3.470226,
      NULL,
      1,
      0.511161,
      1.961702,
      1.895293,
      3.500799,
      3.047828,
      1,
      1,
      1,
      0.489695,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.569389,
      0.556753,
      0.006597,
      2,
      NULL,
      0,
      1,
      0.795803,
      0.782696,
      0.959926,
      3.184260,
      NULL,
      0.579538,
      2.408310,
      1.123759,
      0,
      3.068951,
      1,
      0.207257,
      5.310743,
      1.671821,
      NULL,
      7.003963,
      1,
      2,
      0.896743,
      1.323677,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.975741,
      1.428891,
      1.328230,
      1,
      NULL,
      0,
      0,
      1.796099,
      0,
      0.239303,
      1.018491,
      NULL,
      0.500010,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.460191,
      NULL,
      0.673476,
      0.762784,
      0.454394,
      1,
      0.795526,
      0,
      NULL,
      NULL,
      1,
      3,
      5.322276,
      5,
      0.883856,
      0.489349,
      4.775970,
      7.550286,
      6,
      2,
      7.021743,
      2,
      3,
      5,
      0.944024,
      2.135998,
      NULL,
      0,
      2,
      NULL,
      1.585271,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.703438,
      1,
      0,
      NULL,
      0,
      0.456858,
      1.122276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.882899,
      NULL,
      NULL,
      3,
      3.759930,
      0.432952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576155,
      1.637519,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640345,
      0.795476,
      0.969787,
      5.400412,
      0.110483,
      NULL,
      0.528202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.578134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.342190,
      1,
      0,
      2,
      1.676084,
      NULL,
      0.233364,
      0.481451,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.182639,
      NULL,
      1.790589,
      1.942299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072479,
      '23330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4.280173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


