set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '00',
      19.240086,
      31.983069,
      '2321003',
      64.265086,
      1,
      3,
      NULL,
      '034103',
      NULL,
      '11-12-1976',
      22,
      44.799803,
      0,
      NULL,
      0,
      0.267178,
      1,
      1.839484,
      0.859522,
      0.104977,
      NULL,
      NULL,
      1.886684,
      NULL,
      2,
      NULL,
      2,
      0,
      0,
      1.933678,
      2,
      NULL,
      1.744650,
      1.528187,
      0.100503,
      NULL,
      2,
      0,
      3,
      0.654614,
      NULL,
      1.216623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.372628,
      NULL,
      0,
      1.266271,
      3.334527,
      1.512447,
      2.323546,
      2.657515,
      0,
      1.404281,
      1,
      0.789464,
      0,
      2.523208,
      NULL,
      0,
      NULL,
      0,
      1,
      3.597611,
      0,
      0,
      1.069512,
      0.717937,
      NULL,
      NULL,
      1.029015,
      NULL,
      NULL,
      0.260115,
      1,
      0,
      1.412770,
      NULL,
      0,
      1,
      1.676061,
      0.551466,
      1.909455,
      NULL,
      1.655958,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0.527091,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      3,
      NULL,
      4,
      0.286337,
      0,
      4,
      0,
      1.772476,
      5.061085,
      5,
      0.995570,
      4,
      NULL,
      NULL,
      3.497978,
      8.231750,
      0,
      0,
      0.360140,
      1.589102,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792388,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0.542967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.034515,
      NULL,
      1,
      NULL,
      3.218289,
      1.699235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      1.838206,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5.220284,
      1.267770,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.867222,
      1.517539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.878682,
      0.954710,
      NULL,
      0.258771,
      1.024454,
      1.253959,
      0.977263,
      3,
      0.056717,
      0.593363,
      NULL,
      1.746489,
      0.504426,
      1.170956,
      0,
      0,
      1.478808,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.504213,
      '41032',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0.855866,
      NULL,
      '',
      '',
      NULL,
      2.238863,
      0.387284,
      NULL,
      2,
      1.387006,
      3,
      1,
      NULL);
commit;
end;
/


