set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      NULL,
      6.853238,
      16,
      '4023423',
      105.934517,
      4,
      1.147416,
      1,
      '412124',
      5.901467,
      NULL,
      NULL,
      25,
      1.553822,
      NULL,
      1,
      2.679691,
      1.150753,
      0.040339,
      1.872433,
      0.101402,
      1,
      0,
      0,
      0.140664,
      NULL,
      1,
      NULL,
      1,
      0.952049,
      0,
      7,
      1.635638,
      0.329856,
      1.330711,
      1.545177,
      1,
      4.490415,
      NULL,
      5.445594,
      NULL,
      1.909492,
      0.689955,
      NULL,
      NULL,
      0.136827,
      NULL,
      NULL,
      5.384998,
      2,
      1,
      1.902510,
      1,
      1.288957,
      1,
      1.746193,
      0,
      1,
      3.101671,
      NULL,
      1,
      0,
      1.961732,
      NULL,
      1,
      0.697933,
      1,
      0.752604,
      NULL,
      1.443088,
      5,
      1,
      NULL,
      0.225582,
      0.307645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.053649,
      1.855120,
      1.333625,
      NULL,
      0.387936,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.632000,
      1,
      1,
      1.011350,
      NULL,
      0,
      1.818510,
      1.366491,
      NULL,
      0.592856,
      0.292266,
      0.134831,
      0.894227,
      NULL,
      5.127585,
      2.178319,
      0,
      0.126840,
      0,
      4.900817,
      1.786265,
      2.188606,
      3.285118,
      3,
      5,
      2.115690,
      9,
      1,
      2.436351,
      4,
      0.390740,
      3,
      NULL,
      0.277425,
      NULL,
      NULL,
      7.515536,
      0.593033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1,
      NULL,
      0.811516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254106,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469691,
      0,
      0,
      3,
      6.072622,
      1,
      2.089017,
      1,
      NULL,
      NULL,
      NULL,
      3.015329,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463964,
      3,
      1.440254,
      1.040286,
      2.984101,
      1.014684,
      NULL,
      3,
      NULL,
      2.134032,
      NULL,
      1.241925,
      1.244516,
      NULL,
      1,
      1.578520,
      0.410047,
      NULL,
      1.962343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '30231',
      '',
      '',
      1.955564,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      1,
      1.316563);
commit;
end;
/


