set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '11440423',
      30,
      61,
      '3410432',
      39,
      NULL,
      NULL,
      NULL,
      '314110',
      4,
      ' 2- 3-1979',
      NULL,
      10.469609,
      1.776538,
      NULL,
      NULL,
      2.527878,
      0,
      0,
      0.778256,
      1,
      2,
      0.408062,
      1.970435,
      0.816908,
      NULL,
      0,
      0,
      0.032506,
      0.285740,
      0,
      1,
      NULL,
      0.025093,
      1.246793,
      1.676979,
      1.226363,
      2.784476,
      0,
      1,
      0,
      1.526835,
      1.204793,
      NULL,
      NULL,
      0.329506,
      NULL,
      NULL,
      5.127976,
      1,
      2.618238,
      3.283099,
      0,
      0,
      3.656732,
      3,
      0,
      NULL,
      3.043905,
      0.340888,
      1,
      0,
      0,
      0,
      1,
      1.136234,
      1.739325,
      NULL,
      0,
      NULL,
      5.364117,
      0,
      2,
      1,
      1.550675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1.097659,
      1.479868,
      1,
      1,
      1.361356,
      0.946204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.179546,
      1.690436,
      1.420035,
      0.786497,
      3.489409,
      NULL,
      NULL,
      NULL,
      0.516811,
      3,
      0.307065,
      1.276208,
      2,
      1,
      1,
      3.374851,
      6,
      2,
      2,
      3.361878,
      0.498957,
      4.391357,
      6.680446,
      0.437495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.032609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.124628,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.550705,
      NULL,
      8,
      2.716344,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3,
      1.612354,
      NULL,
      NULL,
      NULL,
      2.644616,
      0.928321,
      1.664289,
      3,
      2.056606,
      1,
      3.803180,
      0.631050,
      NULL,
      NULL,
      0.315323,
      0.066839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659191,
      0.352006,
      2,
      2,
      2,
      1,
      NULL,
      0,
      0.045349,
      2.645202,
      0.909271,
      0,
      1.071677,
      1,
      1,
      0.741156,
      1.909213,
      1,
      0.113231,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0.636911,
      3,
      2.579742,
      3.007040,
      NULL,
      NULL,
      2,
      0,
      NULL);
commit;
end;
/


