set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '222',
      '11013410',
      NULL,
      44,
      NULL,
      175,
      4,
      2.367434,
      2,
      NULL,
      3.721845,
      ' 2-24-1988',
      54.051521,
      55,
      0,
      NULL,
      0,
      3.164716,
      NULL,
      NULL,
      1,
      NULL,
      1.323572,
      0,
      1,
      1,
      2,
      NULL,
      0.871438,
      1.066980,
      1,
      NULL,
      0,
      0.192690,
      2,
      0,
      1.085871,
      0,
      4.583098,
      1,
      0.405844,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705996,
      NULL,
      3,
      1.698122,
      0.093693,
      2,
      0,
      NULL,
      1,
      1.096390,
      2.164639,
      1.541728,
      1.501832,
      1,
      NULL,
      2.565854,
      0,
      1,
      0,
      0,
      1.419986,
      5,
      0,
      NULL,
      0,
      0.649137,
      NULL,
      NULL,
      0.373560,
      NULL,
      NULL,
      1.038094,
      1,
      NULL,
      1.457715,
      0.588675,
      1,
      0.568727,
      0.890992,
      0.394599,
      1.390636,
      0.404499,
      0,
      1,
      1.621309,
      0.042002,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.561161,
      0,
      0,
      1,
      NULL,
      1.935081,
      NULL,
      2,
      1,
      1,
      0,
      0.410181,
      0.866266,
      1.795063,
      0.064990,
      1.325233,
      0.158648,
      2.515490,
      5.299974,
      NULL,
      1,
      NULL,
      3,
      3.388311,
      1.949287,
      0.358410,
      1.882031,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.002419,
      1,
      NULL,
      0,
      1.759720,
      NULL,
      1.749118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      0.375971,
      NULL,
      NULL,
      NULL,
      0.439821,
      0.033080,
      NULL,
      5,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      0.971390,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063878,
      1.927861,
      3,
      0,
      3.650774,
      1,
      1,
      1.981299,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.420727,
      1.319502,
      1.509073,
      1,
      1.288478,
      1.253890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.613235,
      '23301',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      4.746384,
      0.201490,
      NULL,
      NULL,
      NULL,
      3,
      2.947524,
      3.159820,
      NULL);
commit;
end;
/


