set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      NULL,
      NULL,
      67.068829,
      '4141143',
      133,
      1,
      1.385586,
      1,
      '330243',
      4,
      NULL,
      24,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.040698,
      0,
      NULL,
      1.412207,
      0.754405,
      1,
      4,
      1.768543,
      4.712613,
      1.486888,
      0.583187,
      1.714264,
      3.979603,
      0,
      1,
      1,
      0.175267,
      1.363927,
      5.369880,
      1,
      2,
      1.158484,
      0.051499,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      1.292751,
      1.485876,
      0.378442,
      3,
      1.424482,
      1.030896,
      NULL,
      1,
      NULL,
      1.503087,
      2,
      NULL,
      0,
      2,
      0,
      NULL,
      0.936852,
      0,
      4,
      5.337944,
      0,
      NULL,
      1.954648,
      NULL,
      NULL,
      NULL,
      0.027820,
      NULL,
      NULL,
      0.465552,
      1,
      1.321217,
      0,
      0,
      1.881860,
      0.527807,
      1,
      NULL,
      0.721784,
      0,
      1,
      0.759345,
      0,
      1.417059,
      0,
      NULL,
      0.427096,
      1.870300,
      NULL,
      0,
      0.631646,
      1,
      0,
      1.023322,
      NULL,
      3.081168,
      0.629214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979934,
      2.930797,
      1.141861,
      1,
      0.674278,
      NULL,
      4,
      5.756729,
      3.603404,
      2.822843,
      0,
      3,
      0.597483,
      1,
      5,
      2.529842,
      1,
      0,
      7,
      0.321398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.676783,
      1,
      4.750315,
      1.267005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.037459,
      NULL,
      NULL,
      0.830654,
      2.112654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.162465,
      0.862760,
      2.840028,
      1,
      0.341776,
      1,
      9.070382,
      0.539822,
      2,
      1.326514,
      0.539386,
      0,
      4.441230,
      1.820632,
      NULL,
      NULL,
      1,
      5.099705,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810286,
      NULL,
      3,
      1,
      1.650019,
      NULL,
      1.614717,
      2.747535,
      NULL,
      0.101461,
      1,
      1,
      0.082570,
      0.069231,
      0,
      NULL,
      1.465644,
      0,
      1.920821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.979277,
      '43133',
      '',
      '',
      1.328072,
      '',
      NULL,
      NULL,
      0.737114,
      '',
      NULL,
      '',
      0,
      5,
      0.841913,
      4.266228,
      3,
      2.349328,
      1,
      2,
      NULL);
commit;
end;
/


