set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '04412324',
      11.223083,
      38,
      NULL,
      12,
      4,
      NULL,
      2,
      '042414',
      NULL,
      ' 7-22-1974',
      34,
      33,
      1,
      NULL,
      1.446764,
      3.943782,
      0,
      0,
      0,
      1.724597,
      0,
      0,
      0.257808,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.309028,
      0,
      0,
      0,
      0,
      0,
      1.624375,
      1.921023,
      NULL,
      3,
      0.767621,
      1.309022,
      0.294364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      0,
      NULL,
      3.771418,
      NULL,
      1.093169,
      NULL,
      2.980293,
      1.260278,
      NULL,
      1.842544,
      0.675303,
      1.967803,
      2.186946,
      0,
      1,
      0.855207,
      NULL,
      1,
      5,
      0,
      0,
      0.298648,
      0.141946,
      NULL,
      NULL,
      0.746868,
      NULL,
      NULL,
      1.143823,
      0,
      0.107032,
      0.351136,
      0.873862,
      0,
      0.829415,
      1,
      1.883345,
      0,
      1.473914,
      0.946522,
      1,
      0,
      NULL,
      0,
      1,
      0.021387,
      NULL,
      NULL,
      1.514109,
      1.745994,
      1,
      0,
      0.704094,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0.401397,
      NULL,
      3,
      1.454397,
      1.460676,
      0,
      4.689357,
      4.197113,
      1,
      5.254890,
      2,
      2,
      2.746380,
      NULL,
      1.309871,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.169904,
      NULL,
      0,
      1.297899,
      1,
      0.746236,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124243,
      1.851316,
      1.034611,
      1.736349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611652,
      0.924237,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692381,
      1,
      0.721562,
      NULL,
      0.198671,
      1,
      2.310235,
      1,
      NULL,
      NULL,
      1.004148,
      NULL,
      1.689306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735772,
      0.623551,
      0,
      2,
      1.163844,
      1,
      2,
      1.646570,
      1.226786,
      NULL,
      0.826212,
      1,
      1,
      NULL,
      0.674756,
      0,
      1,
      0,
      0.171972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.435154,
      '14314',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      0.590676,
      NULL,
      1.089205,
      0,
      1,
      1.604364,
      1,
      3,
      NULL);
commit;
end;
/


