set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '22133444',
      61.878899,
      NULL,
      '2334034',
      NULL,
      NULL,
      2.188893,
      1,
      NULL,
      NULL,
      '10-15-1998',
      9.264280,
      49.574235,
      0.602981,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      3.122791,
      0.043324,
      1.658018,
      NULL,
      2,
      0,
      2.912238,
      0.955084,
      NULL,
      0.189972,
      0,
      NULL,
      1.041819,
      0,
      NULL,
      1,
      5,
      NULL,
      5,
      NULL,
      1,
      1.542154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.879093,
      NULL,
      0,
      2,
      1.469105,
      1,
      NULL,
      3.864980,
      1.833862,
      3,
      2,
      NULL,
      1.960671,
      NULL,
      NULL,
      0.462010,
      1.180657,
      0.521893,
      1.301508,
      1,
      0.790039,
      1.867175,
      0,
      1,
      NULL,
      1.273273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.039763,
      0.646581,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1.344927,
      1.821556,
      1.278643,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.047012,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.007053,
      3,
      4.421375,
      1,
      1,
      0.990432,
      5.364820,
      1.226229,
      NULL,
      NULL,
      1.417335,
      4,
      0,
      NULL,
      1.998120,
      0.168273,
      5,
      0,
      0,
      4.357230,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590423,
      1,
      NULL,
      1,
      1.761595,
      1,
      1.479328,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.971982,
      NULL,
      2,
      3.813385,
      0.380031,
      5,
      1.591609,
      1.385643,
      1.865543,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7,
      NULL,
      5.034753,
      2,
      1.088282,
      NULL,
      NULL,
      NULL,
      0.510844,
      6.124572,
      0.572647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.922725,
      1.565131,
      NULL,
      1,
      1,
      1.774775,
      NULL,
      1,
      1,
      NULL,
      0.445351,
      1,
      1,
      1.635920,
      0.263318,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '22024',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.568096,
      '',
      '',
      '',
      2.911516,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      0,
      1);
commit;
end;
/


