set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      '11043132',
      24,
      NULL,
      NULL,
      8,
      3,
      0.524164,
      2,
      '243410',
      3,
      ' 9-11-1985',
      33,
      45,
      1.097101,
      NULL,
      0,
      1,
      0,
      1.274500,
      1,
      0.404217,
      NULL,
      1,
      1,
      0,
      3,
      0,
      1,
      1,
      NULL,
      5.525747,
      4,
      1.898156,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.858351,
      NULL,
      NULL,
      0.521672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.075289,
      NULL,
      1.502983,
      1.467798,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.777125,
      1.908152,
      0.934833,
      0,
      NULL,
      0.806905,
      1.922262,
      1.825934,
      1,
      4,
      NULL,
      0,
      1,
      0.279044,
      NULL,
      NULL,
      1.795366,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.017992,
      NULL,
      1,
      0.586586,
      NULL,
      0.027183,
      NULL,
      1.243601,
      1,
      NULL,
      0.539115,
      NULL,
      1,
      NULL,
      1.195091,
      1,
      NULL,
      0.155426,
      NULL,
      1.407694,
      NULL,
      0.703449,
      1.322521,
      0.514981,
      1,
      0,
      0.392124,
      NULL,
      4,
      1,
      1,
      1,
      1.401067,
      0,
      0,
      NULL,
      7.835341,
      3.084967,
      4.376574,
      NULL,
      1.233976,
      2,
      3,
      0.860954,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410168,
      1.915937,
      0,
      1,
      1.800329,
      1,
      0.296534,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544509,
      NULL,
      NULL,
      NULL,
      2.133352,
      0.531318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.173460,
      2,
      0.559488,
      NULL,
      NULL,
      NULL,
      3,
      1.520110,
      2.278481,
      4.856660,
      1,
      1,
      4,
      0.791717,
      NULL,
      NULL,
      2.921537,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.543661,
      3.734436,
      NULL,
      0.362967,
      NULL,
      0,
      1,
      0,
      1.276503,
      NULL,
      NULL,
      NULL,
      0.927701,
      NULL,
      0,
      1.651918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277656,
      '12101',
      NULL,
      '',
      0.224287,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      5.154952,
      2.735979,
      1,
      2,
      1,
      3,
      2.366551,
      NULL,
      1.404961);
commit;
end;
/


