set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      '41200013',
      NULL,
      17.424446,
      '4004441',
      81,
      2,
      3.363942,
      0,
      '111013',
      5,
      ' 0-22-1977',
      39.305705,
      3,
      1,
      NULL,
      NULL,
      2,
      0,
      1.598705,
      0,
      NULL,
      1,
      0,
      0,
      1,
      2.464925,
      NULL,
      NULL,
      3.916599,
      1,
      3.971032,
      0,
      0.318050,
      0,
      NULL,
      NULL,
      1,
      1.211539,
      1,
      1,
      NULL,
      1,
      0.025649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.271446,
      NULL,
      1.760302,
      0.978234,
      1.529889,
      0,
      NULL,
      0.441803,
      2,
      1,
      1.687633,
      1,
      3.934878,
      0,
      1.328007,
      1,
      1,
      1,
      0.284912,
      1,
      0.679483,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.193718,
      0,
      NULL,
      0.984798,
      0.863016,
      NULL,
      0.315496,
      1,
      0,
      1.895324,
      1,
      0,
      NULL,
      0.542479,
      1.942368,
      1.944044,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0.931138,
      1.656134,
      0.452543,
      1,
      NULL,
      5,
      6,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      5.274840,
      NULL,
      4,
      4.942815,
      0,
      NULL,
      4,
      1.597958,
      2,
      1.880596,
      NULL,
      NULL,
      3.114438,
      0.053040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883506,
      NULL,
      0,
      1,
      0.690056,
      1.281233,
      1.001551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.043493,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.157058,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.915672,
      NULL,
      1,
      NULL,
      0.471452,
      0,
      NULL,
      NULL,
      0.470605,
      6.349180,
      0.737318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496073,
      0,
      0.905391,
      0,
      0,
      NULL,
      NULL,
      2.462727,
      1,
      1.926784,
      0,
      0.213143,
      0,
      1.850458,
      NULL,
      1,
      1,
      1,
      0.184144,
      0.788630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '21303',
      '',
      '',
      1.135757,
      '',
      NULL,
      '',
      0.677309,
      '',
      '',
      '',
      5.382643,
      7,
      2.201083,
      NULL,
      3.542573,
      1.583809,
      0.718681,
      0,
      1.180739);
commit;
end;
/


