set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0213',
      '20201302',
      24.455492,
      NULL,
      '2042121',
      53,
      6,
      2,
      3,
      NULL,
      5.107115,
      '11- 7-1985',
      37,
      27.025474,
      NULL,
      NULL,
      6.740208,
      2.873798,
      1.973692,
      NULL,
      3.615510,
      NULL,
      NULL,
      1,
      0.699919,
      1,
      7,
      0.638458,
      7,
      1.678145,
      10.086456,
      3,
      5,
      1.703891,
      2,
      0.364854,
      1,
      0.801835,
      4,
      0,
      2.639580,
      0.298363,
      1,
      0.918531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.324054,
      1,
      0.198577,
      0,
      0,
      0.767533,
      3.367796,
      2.556461,
      0.075772,
      3,
      0,
      0.858650,
      0,
      3,
      1.336342,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.867047,
      NULL,
      0,
      0,
      NULL,
      1.396015,
      NULL,
      NULL,
      1.236784,
      NULL,
      NULL,
      0.856576,
      9,
      1.655514,
      0,
      NULL,
      1.958318,
      0.151758,
      1.654309,
      0,
      1,
      NULL,
      NULL,
      0,
      0.923509,
      NULL,
      0,
      0.284388,
      0.348754,
      0,
      NULL,
      0,
      8,
      0.850835,
      0,
      9,
      1.128644,
      3.280621,
      1,
      6,
      8,
      NULL,
      0.821671,
      3,
      0,
      3,
      0.518668,
      1.203208,
      5.452102,
      9,
      0,
      NULL,
      4,
      3.074237,
      NULL,
      7.279608,
      2.365896,
      1.102051,
      NULL,
      2.283425,
      NULL,
      1,
      1.386346,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0.167445,
      1.992047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      3,
      NULL,
      7.373926,
      0,
      1.718237,
      0.246154,
      1.065971,
      5.845404,
      6,
      2.854677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212749,
      2,
      NULL,
      2,
      1.257495,
      0.519549,
      NULL,
      NULL,
      0.397471,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.508574,
      2.128240,
      1.710822,
      NULL,
      NULL,
      3,
      2.408424,
      0,
      3.089732,
      0,
      1,
      1.737601,
      0.624758,
      1,
      1.461074,
      0.507467,
      0,
      NULL,
      1.791933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.703924,
      '04333',
      '',
      '',
      0,
      '',
      '',
      '',
      1.420368,
      '',
      '',
      '',
      4,
      0.795430,
      NULL,
      NULL,
      2.806041,
      NULL,
      NULL,
      1.323564,
      7);
commit;
end;
/


