set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9745837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '404',
      '13401142',
      30,
      NULL,
      NULL,
      0.361985,
      1,
      3.707988,
      1,
      NULL,
      0,
      NULL,
      50.783185,
      72.455963,
      0,
      NULL,
      2.552960,
      NULL,
      3.700202,
      1.409287,
      NULL,
      3,
      3.375926,
      NULL,
      1,
      1,
      3.159576,
      0.879240,
      0.792560,
      3.616347,
      3,
      1.799546,
      0,
      1.846541,
      0.339160,
      1,
      0,
      0.503833,
      0.110989,
      1,
      1.034900,
      3.122650,
      NULL,
      1,
      NULL,
      NULL,
      0.434484,
      NULL,
      NULL,
      1,
      1,
      1.776666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732077,
      0.225695,
      1.717009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1,
      NULL,
      2.738992,
      3.310417,
      NULL,
      NULL,
      1.631307,
      0,
      NULL,
      1.177984,
      1.658970,
      NULL,
      NULL,
      0.018559,
      0.156740,
      0.453597,
      0.912667,
      NULL,
      0,
      1,
      9,
      0.577048,
      1,
      0.079738,
      NULL,
      0,
      NULL,
      NULL,
      0.592898,
      0.205550,
      0,
      1,
      0.044263,
      0,
      0.841822,
      4.771342,
      5.122133,
      7,
      0,
      NULL,
      NULL,
      7,
      5,
      0,
      NULL,
      1,
      3.623470,
      0.308256,
      1.427976,
      4,
      1.281524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464712,
      0.614953,
      0,
      0,
      1.869727,
      3,
      0.046232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076971,
      NULL,
      NULL,
      1.921936,
      NULL,
      NULL,
      NULL,
      1.012499,
      1.310456,
      0.303249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.207371,
      1.080995,
      NULL,
      1.872525,
      3,
      3.680989,
      1.959278,
      1.254916,
      1,
      0,
      1,
      0,
      1.461043,
      1,
      NULL,
      1.949983,
      NULL,
      NULL,
      1.785548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '31304',
      '',
      '',
      1.487134,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      0.533365,
      1,
      2,
      3,
      0.405297,
      0,
      1,
      0.650304);
commit;
end;
/


