set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9745837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41412423',
      62.596014,
      63,
      NULL,
      64,
      NULL,
      0,
      NULL,
      '100440',
      5,
      ' 8-19-1978',
      57.858130,
      53.055112,
      1.365480,
      NULL,
      1.116011,
      NULL,
      2,
      0.022839,
      1.720304,
      3,
      1.335967,
      0.258759,
      3.707226,
      NULL,
      NULL,
      NULL,
      0,
      0.485756,
      NULL,
      2.358880,
      0,
      0,
      0,
      1,
      0.367489,
      1.433374,
      2.770034,
      NULL,
      3,
      2.249706,
      0.089210,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218855,
      0,
      0.851689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094993,
      NULL,
      0.776735,
      1.381935,
      0.045519,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.608362,
      1,
      0,
      1.518300,
      1,
      NULL,
      0,
      NULL,
      0.519322,
      0,
      0,
      0.925144,
      0.567940,
      0,
      5,
      1.169415,
      2.099595,
      1.663263,
      1.515352,
      NULL,
      5.780379,
      0.998593,
      2,
      1,
      0,
      5,
      0.208215,
      4.019444,
      NULL,
      5,
      NULL,
      4.204311,
      NULL,
      NULL,
      0,
      4.134965,
      0.928435,
      NULL,
      NULL,
      1.308411,
      0.562315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.106413,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.455862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197658,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.095170,
      0,
      NULL,
      NULL,
      NULL,
      0.756706,
      NULL,
      0,
      1.915303,
      0.331813,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.794276,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669325,
      NULL,
      1.984565,
      0.768817,
      1.023499,
      1.930483,
      1.647843,
      2.409361,
      NULL,
      1.881898,
      2,
      0.298760,
      1.800658,
      1,
      0.381657,
      1.662336,
      1.852413,
      NULL,
      0,
      1.127782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.715216,
      '12414',
      '',
      '',
      1.085072,
      '',
      NULL,
      '',
      0.565717,
      '',
      '',
      '',
      0,
      3.104343,
      NULL,
      NULL,
      3,
      1.779846,
      1,
      1.922246,
      0);
commit;
end;
/


