set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9745837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3224',
      '14333220',
      19,
      45.186175,
      '1330001',
      5.431308,
      0,
      1,
      NULL,
      '124012',
      0,
      ' 3-25-1995',
      122.525002,
      189,
      1,
      NULL,
      2.435102,
      0.402048,
      3,
      NULL,
      1,
      1.497450,
      1.868193,
      3,
      1.996310,
      0,
      0,
      NULL,
      1,
      4.641865,
      3.071026,
      1,
      NULL,
      0.798826,
      0,
      0.626607,
      0,
      1.796159,
      2.375395,
      0,
      NULL,
      0.311563,
      0.447510,
      1.788782,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.290718,
      1.513320,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793111,
      0.420645,
      1.822850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843316,
      1,
      NULL,
      0.803079,
      NULL,
      2,
      1.122125,
      1.927259,
      1,
      0.931926,
      0.676657,
      0,
      0,
      1.374603,
      NULL,
      0.059587,
      0,
      NULL,
      1,
      NULL,
      1.545474,
      0.303604,
      1.817925,
      NULL,
      NULL,
      0,
      3,
      1.225085,
      0,
      0,
      1.701494,
      NULL,
      0,
      0.512359,
      2.609038,
      3,
      4,
      2,
      1.451207,
      1.059156,
      4.790731,
      5.433688,
      NULL,
      8,
      5.607010,
      5.741087,
      NULL,
      3.828460,
      1.668316,
      NULL,
      NULL,
      0.737498,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.611492,
      NULL,
      0,
      1,
      0.710138,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.006574,
      NULL,
      NULL,
      1.981155,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.873279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.258029,
      NULL,
      0.664750,
      0,
      NULL,
      NULL,
      0.662011,
      1.548210,
      2,
      0.083376,
      NULL,
      1.462906,
      0,
      0,
      1.287318,
      0.917756,
      0.431246,
      1.312577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242794,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912171,
      0,
      NULL,
      NULL,
      0.859095,
      0.434011,
      1.648291,
      0,
      3.095722,
      '42143',
      NULL,
      '',
      1.271385,
      '',
      '',
      '',
      0.011576,
      '',
      '',
      '',
      1,
      0.953814,
      1,
      4.257911,
      3,
      1,
      1.952665,
      1,
      0);
commit;
end;
/


