set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '2231432',
      NULL,
      6,
      1.658055,
      3,
      '001103',
      NULL,
      ' 0- 5-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540834,
      0,
      NULL,
      0,
      1,
      2,
      1.528275,
      NULL,
      NULL,
      NULL,
      1.629660,
      1.091690,
      0.836759,
      0.308024,
      0,
      0,
      0.141106,
      0,
      0.779112,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      1.296858,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      0,
      0,
      3.068582,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.277154,
      1.201080,
      0.737396,
      0.286341,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1.847552,
      0,
      1,
      NULL,
      NULL,
      0.810579,
      0,
      NULL,
      NULL,
      1.934028,
      1.271005,
      0.848471,
      1,
      NULL,
      1.222651,
      0.095592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838721,
      0,
      NULL,
      0.131992,
      1.196444,
      1.649930,
      0,
      4.207611,
      NULL,
      4.926374,
      1.085094,
      NULL,
      1.335167,
      1,
      NULL,
      0.991884,
      NULL,
      NULL,
      6,
      1.077921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445434,
      2,
      1,
      0.834304,
      0,
      NULL,
      1.150540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.765102,
      NULL,
      8.030307,
      3,
      3.789005,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.170615,
      0,
      0.690860,
      NULL,
      1,
      1.243905,
      NULL,
      0,
      0.801547,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.270551,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855066,
      1.682709,
      0.698760,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.890496,
      0.966757,
      1.420783,
      1.199138,
      1,
      0,
      0,
      1.327699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '33413',
      '',
      1.232881,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


