set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      NULL,
      NULL,
      56.904510,
      '1021202',
      94.202335,
      4,
      1.809646,
      NULL,
      NULL,
      1,
      '10-14-1999',
      14,
      55.471210,
      NULL,
      NULL,
      1,
      3.981361,
      1,
      0.630032,
      0.376684,
      1,
      NULL,
      3,
      1.928282,
      NULL,
      0.625515,
      0.576787,
      NULL,
      1.419288,
      NULL,
      NULL,
      3.077787,
      0,
      NULL,
      NULL,
      1.544950,
      1.824650,
      3.699129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136042,
      0,
      1.876671,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837076,
      1,
      0.672379,
      1.593309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383659,
      0,
      0.864937,
      1,
      1.792057,
      0.037412,
      NULL,
      NULL,
      0.961155,
      0.261482,
      0,
      1,
      1,
      0.333969,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.442370,
      1.368812,
      0.943196,
      0.072412,
      NULL,
      0,
      0.580372,
      1,
      0,
      1,
      NULL,
      0.683709,
      1.516833,
      0,
      NULL,
      NULL,
      5.084067,
      0.428291,
      1,
      4,
      NULL,
      0,
      6.670733,
      2.877200,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.744425,
      1,
      0,
      1.452910,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.619823,
      0.480575,
      0.675830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.619570,
      0,
      0,
      0,
      0.544457,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.092030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.730905,
      NULL,
      1.820727,
      1,
      NULL,
      0.318087,
      0.667643,
      1,
      0.322319,
      0.665046,
      0,
      0,
      1,
      NULL,
      0.866789,
      NULL,
      NULL,
      1.306772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.062926,
      '03040',
      NULL,
      '',
      0.291306,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      1,
      0,
      2,
      5,
      5.144561,
      NULL,
      0.555220,
      NULL);
commit;
end;
/


