set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0304',
      '42040414',
      49,
      77.986010,
      '2401213',
      141.720387,
      NULL,
      1,
      1,
      '333324',
      5.044458,
      ' 4-26-1984',
      21,
      25.847190,
      NULL,
      NULL,
      1.097085,
      1.553901,
      1.659622,
      0.242733,
      0,
      NULL,
      1,
      1.047953,
      0.897003,
      NULL,
      NULL,
      NULL,
      0.380707,
      1,
      NULL,
      NULL,
      NULL,
      0.808510,
      1.647166,
      1,
      0.906887,
      NULL,
      3.819547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.052217,
      1.910790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263799,
      1.690194,
      1,
      0.522907,
      0,
      1.804513,
      0.219590,
      1.289627,
      1.670396,
      4,
      0,
      NULL,
      0.013855,
      3,
      1.865267,
      1,
      1.387867,
      1.965513,
      1.248343,
      NULL,
      0.166000,
      NULL,
      NULL,
      3.506893,
      1.472493,
      NULL,
      4.713733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118377,
      0,
      NULL,
      1.281388,
      0,
      8,
      NULL,
      7,
      9,
      2.390231,
      1.189393,
      NULL,
      7,
      3.283379,
      0,
      NULL,
      0,
      NULL,
      NULL,
      7.686923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424599,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933445,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767107,
      0.585163,
      0.419875,
      1,
      0.640825,
      NULL,
      9,
      0.694646,
      0.410394,
      NULL,
      NULL,
      NULL,
      5.016635,
      0,
      6,
      4.578551,
      0.255770,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.858977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.675982,
      2.381917,
      NULL,
      1,
      0.216291,
      NULL,
      1,
      0.753382,
      0.009329,
      0,
      0,
      1.717571,
      1,
      0.855233,
      1.769982,
      1,
      0.104694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.108329,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5.960775,
      3.407443,
      3,
      3,
      2,
      3.601919,
      1,
      3,
      NULL);
commit;
end;
/


