set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '03334424',
      NULL,
      57.568609,
      '0112212',
      9.693440,
      3,
      0.358358,
      1,
      '011221',
      0,
      ' 7- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.581772,
      0,
      0,
      1,
      0.753980,
      1,
      NULL,
      0.921276,
      0.631833,
      NULL,
      NULL,
      0,
      0.900022,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.451276,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.218199,
      NULL,
      1,
      1,
      0.804649,
      1.318410,
      1,
      1,
      0.987581,
      0.044569,
      0.138734,
      NULL,
      1.984973,
      1,
      2,
      3,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1.993893,
      NULL,
      NULL,
      3.299040,
      NULL,
      2.909772,
      0.172090,
      0,
      NULL,
      3,
      1.993363,
      0.066158,
      0,
      1,
      NULL,
      0.987764,
      NULL,
      1,
      0.339684,
      0,
      1.663337,
      NULL,
      NULL,
      NULL,
      1.816854,
      6.033643,
      3,
      2.988198,
      0.444359,
      8,
      NULL,
      4.943489,
      NULL,
      2.156148,
      6,
      NULL,
      0,
      NULL,
      8,
      1.145043,
      2.839140,
      2.528616,
      7,
      4,
      1,
      0,
      3,
      2.920604,
      4.725261,
      5,
      1,
      0.634282,
      0.060186,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840463,
      0,
      2,
      0,
      0.531636,
      3,
      0.435298,
      0.380922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241969,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.519604,
      5,
      NULL,
      1,
      1.992452,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.805684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089187,
      0.043479,
      NULL,
      3.718759,
      0,
      3,
      NULL,
      1,
      2.881685,
      1,
      0,
      1,
      0.638109,
      1.500735,
      1,
      0,
      0,
      0.081472,
      0.304153,
      1.860634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '14413',
      NULL,
      NULL,
      1.089633,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5.556336,
      3.197261,
      NULL,
      2,
      0,
      NULL,
      3.971169,
      3.524279,
      6.607060);
commit;
end;
/


