set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '14121221',
      7,
      NULL,
      '3323230',
      NULL,
      1,
      2,
      2,
      '031440',
      NULL,
      ' 9- 0-1995',
      NULL,
      128.166119,
      NULL,
      NULL,
      3,
      0.212942,
      1,
      NULL,
      1.303890,
      3,
      1,
      0.870529,
      2.183313,
      0.321674,
      0,
      NULL,
      0.366532,
      0.403124,
      1,
      0.682348,
      1.081888,
      0,
      1.877347,
      0.934183,
      0.172738,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.754063,
      NULL,
      11,
      NULL,
      0,
      1.740581,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.855051,
      3.646079,
      4.091435,
      2,
      1.061850,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      7.214678,
      5,
      NULL,
      NULL,
      NULL,
      2.424627,
      6,
      5,
      NULL,
      2.073789,
      11,
      NULL,
      5,
      1.895751,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.556981,
      1,
      0,
      3,
      0.516286,
      6.971993,
      1,
      NULL,
      3,
      0.545334,
      NULL,
      2,
      NULL,
      6.632104,
      6,
      2.344077,
      4.300649,
      9,
      8.708232,
      6.344640,
      0.195951,
      8,
      6.354426,
      2.260376,
      2.037214,
      7.954544,
      5.695798,
      2.660222,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.591080,
      9,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.263686,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408629,
      1.726797,
      1,
      1.083141,
      0,
      3.729859,
      2,
      0.777558,
      NULL,
      3.334746,
      2.330565,
      0.681995,
      0,
      0.214235,
      1.238375,
      1.608120,
      NULL,
      0,
      0,
      1.209089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '1240',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      4.583964,
      5,
      1,
      7.900726,
      0.189943,
      3,
      0,
      3.921795,
      3);
commit;
end;
/


