set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '0211104',
      13.303445,
      0,
      1,
      3,
      NULL,
      1,
      ' 9-12-1989',
      64,
      NULL,
      NULL,
      NULL,
      0.224066,
      0,
      3.741340,
      NULL,
      0.341066,
      0,
      0,
      3.514741,
      1,
      0,
      0,
      NULL,
      NULL,
      0.676233,
      0,
      6,
      3.079685,
      0,
      NULL,
      0,
      3.870421,
      0.454041,
      NULL,
      NULL,
      NULL,
      1.693833,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      3,
      0,
      1.965732,
      2.424784,
      2.199225,
      3,
      3,
      3.117873,
      2.465535,
      2,
      0.800991,
      1,
      3,
      1.960845,
      NULL,
      3.102626,
      4,
      0,
      NULL,
      4,
      NULL,
      2,
      0,
      0.271834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135988,
      1.086737,
      NULL,
      1,
      0,
      2,
      1.857752,
      NULL,
      0.432113,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      1.854474,
      1,
      1,
      0.355077,
      NULL,
      0,
      3,
      2.467596,
      1,
      5.977840,
      0.664780,
      2,
      1.150591,
      1,
      NULL,
      3.732616,
      3,
      0.566846,
      1.609092,
      2.314246,
      0,
      5.291736,
      0.253988,
      NULL,
      6.256799,
      NULL,
      3,
      1.651822,
      6,
      NULL,
      1.896502,
      0,
      NULL,
      1,
      1.142190,
      NULL,
      7,
      0.509803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998182,
      0.784734,
      0,
      NULL,
      1,
      1.830283,
      0,
      0.291473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.763677,
      0.460895,
      1,
      5,
      3.584625,
      2.723721,
      NULL,
      0,
      0,
      0.947703,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747117,
      0.002263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.389991,
      2,
      0,
      0.405783,
      2,
      0.964931,
      3,
      0,
      1,
      1,
      0.662829,
      0.690196,
      0,
      NULL,
      0,
      NULL,
      1,
      1.288286,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.843139,
      '41322',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


