set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '13',
      19,
      15.610601,
      '0113210',
      10.085569,
      NULL,
      1,
      1,
      '043142',
      3.967125,
      NULL,
      24.676436,
      12,
      0,
      NULL,
      0.654936,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.685851,
      0,
      NULL,
      NULL,
      NULL,
      0.580829,
      1.721739,
      1,
      1,
      1,
      1.494843,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      3.610109,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.407771,
      1,
      0,
      1,
      3.910030,
      1,
      2,
      0,
      NULL,
      0.159115,
      1.182786,
      2,
      1,
      NULL,
      1.198062,
      2.107482,
      1,
      2,
      0,
      NULL,
      5.424400,
      1,
      0,
      3,
      1.545865,
      NULL,
      NULL,
      0.131460,
      NULL,
      NULL,
      1,
      NULL,
      0.247687,
      1.150786,
      NULL,
      3.293861,
      4.142161,
      0,
      1.141534,
      1.316784,
      1,
      1,
      1,
      2.993295,
      1,
      1.317819,
      0.952747,
      0.760261,
      0.677093,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0.395122,
      1.659971,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.572933,
      4,
      0,
      NULL,
      3,
      NULL,
      7.145826,
      4.901111,
      4.446288,
      NULL,
      4.538379,
      0,
      2,
      8,
      6,
      NULL,
      0.382116,
      NULL,
      8.753984,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128001,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.318447,
      1,
      3,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      2.609017,
      NULL,
      0.838168,
      NULL,
      NULL,
      NULL,
      NULL,
      5.998970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.569119,
      2.194096,
      1.015600,
      0,
      3.421042,
      NULL,
      NULL,
      2.274051,
      0.381455,
      NULL,
      1,
      NULL,
      1.441734,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.363585,
      '02121',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.138649,
      '',
      '',
      '',
      1.649574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


