set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      NULL,
      3.006575,
      NULL,
      '3342212',
      7.105056,
      2,
      0,
      1,
      NULL,
      0,
      ' 3-19-1997',
      46,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.202538,
      1.671682,
      0,
      1,
      2,
      0.063547,
      1.504000,
      NULL,
      0.477488,
      NULL,
      0.045864,
      0,
      0,
      4,
      NULL,
      NULL,
      0,
      5.691997,
      1,
      5.841353,
      NULL,
      0,
      2,
      0.400986,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      0,
      2.834220,
      3.532524,
      3.476919,
      2.598137,
      NULL,
      0,
      3,
      1.132929,
      3,
      0.377094,
      1,
      3,
      3.500185,
      1.598704,
      1.723454,
      0.175805,
      0,
      0,
      2,
      1.162504,
      NULL,
      NULL,
      0.092717,
      NULL,
      NULL,
      1.463219,
      NULL,
      NULL,
      0.112298,
      0.816204,
      0.996305,
      5,
      1,
      1,
      0,
      1,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      1.437143,
      NULL,
      NULL,
      0.358795,
      2.437350,
      1,
      NULL,
      1,
      1.519095,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514529,
      NULL,
      5.089911,
      0,
      6.292840,
      4,
      7.313464,
      NULL,
      5,
      2.233327,
      7,
      1.653114,
      6,
      NULL,
      5,
      0.356115,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.459206,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011099,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2,
      0.704729,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.342511,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304526,
      3,
      2.032170,
      0,
      NULL,
      0.874870,
      1,
      NULL,
      1,
      1,
      0.910878,
      0.334752,
      0.870102,
      1.983688,
      0.312054,
      1,
      0,
      0,
      0,
      0.083452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.790693,
      '11322',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


