set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      28.128340,
      25.910120,
      '0103244',
      NULL,
      6,
      1.947228,
      3,
      '144014',
      3.047697,
      ' 5- 7-1984',
      23,
      NULL,
      1.206322,
      NULL,
      13,
      0,
      0.969899,
      0.235522,
      2,
      NULL,
      0.088337,
      1.647584,
      0,
      0,
      6.642458,
      0.687656,
      0,
      1.959595,
      NULL,
      0.547755,
      NULL,
      NULL,
      1.901368,
      1,
      1,
      0.950765,
      NULL,
      1,
      NULL,
      1.237510,
      1.829979,
      0.446474,
      NULL,
      NULL,
      0.691606,
      NULL,
      NULL,
      7.919660,
      1,
      NULL,
      1,
      0.505624,
      0.052798,
      2.592564,
      1.708997,
      1.380595,
      3,
      NULL,
      1.206149,
      0.776739,
      1,
      0.479438,
      1,
      0,
      NULL,
      3.385677,
      2.371785,
      1.006230,
      0,
      7.596754,
      0,
      2,
      1,
      1.579512,
      NULL,
      NULL,
      0.949326,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.737976,
      0,
      NULL,
      0,
      1.643825,
      0,
      NULL,
      2,
      0.127476,
      0.142005,
      3,
      0.484598,
      1,
      0,
      0,
      NULL,
      NULL,
      1.476067,
      NULL,
      3.450669,
      0,
      4.714237,
      1.093219,
      1.048196,
      1.185271,
      NULL,
      1,
      1,
      1,
      4,
      NULL,
      0.088062,
      3,
      7.215874,
      9.305198,
      9,
      NULL,
      6,
      5.406130,
      4.435147,
      4,
      2.795068,
      5.445161,
      NULL,
      5,
      3,
      1.207158,
      1.394206,
      3.064201,
      1.549772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706509,
      0.641221,
      2,
      1,
      1.923924,
      1,
      1,
      0.591275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.166346,
      1.771820,
      1.807430,
      4,
      0.536766,
      4.213753,
      0.868390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.019950,
      1,
      NULL,
      0.678212,
      2,
      NULL,
      3,
      NULL,
      1.295579,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.390199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11142',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      1.167709,
      '',
      '',
      '',
      3.225025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


