set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      NULL,
      1.078355,
      NULL,
      '4040441',
      37,
      5,
      3,
      3,
      '103410',
      3.576809,
      ' 3-29-1999',
      49,
      46,
      1.149229,
      NULL,
      0.216596,
      0,
      0,
      0.678125,
      0.812192,
      0,
      0,
      2.117283,
      1.064882,
      0,
      NULL,
      1.122559,
      NULL,
      1.365548,
      NULL,
      1.348202,
      NULL,
      1,
      1,
      1.163143,
      2,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      6,
      NULL,
      0.218920,
      1.157869,
      0,
      3,
      1.039786,
      1.208723,
      2.158856,
      0.530000,
      0,
      0,
      0,
      0,
      3.511136,
      0.324122,
      NULL,
      0.701677,
      1,
      1.303556,
      0.226164,
      3.938102,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.293203,
      NULL,
      NULL,
      0.220216,
      1.416132,
      0.117945,
      NULL,
      NULL,
      0.675008,
      NULL,
      1.841162,
      0.220863,
      0,
      1,
      1.770387,
      1,
      2.228703,
      0.021208,
      1,
      0.120220,
      1,
      NULL,
      NULL,
      0.888663,
      0.120000,
      3,
      NULL,
      3.912208,
      0.899506,
      3.979745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.091684,
      4,
      1,
      0.775895,
      4.249207,
      8.176258,
      9.137745,
      1,
      NULL,
      0.260974,
      1.985678,
      8.738898,
      2.041576,
      3,
      NULL,
      3,
      3.293198,
      0.764194,
      NULL,
      NULL,
      0.976874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501077,
      2,
      NULL,
      1,
      0.409636,
      0,
      1.226029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.812476,
      1.130322,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741743,
      0,
      1.998502,
      1,
      1,
      0.866095,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.884012,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.034863,
      0.856398,
      2,
      2,
      1.563431,
      3.001250,
      0.133191,
      3,
      2,
      1,
      NULL,
      1,
      1,
      0.541243,
      1,
      0.136624,
      1.790469,
      1.978213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43120',
      '',
      '',
      1.855635,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4.480933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


