set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      NULL,
      24.491401,
      3.640836,
      '0130322',
      43.257495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      33.926497,
      53,
      1.677860,
      NULL,
      2,
      0.170227,
      NULL,
      1,
      0.587740,
      1.560589,
      0.510358,
      3,
      0.775186,
      0,
      1.673315,
      0.938155,
      4.990125,
      1.190454,
      1,
      1.352486,
      0.414261,
      0.093187,
      0,
      0,
      6,
      0.254286,
      1,
      NULL,
      5.938156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      3,
      NULL,
      1,
      1.015592,
      1.038097,
      3,
      0.820813,
      0,
      3,
      0,
      0.521737,
      NULL,
      2.515540,
      1.748597,
      0,
      1.583447,
      1,
      0.549029,
      1,
      NULL,
      0,
      2,
      3.954933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.605136,
      NULL,
      1.735320,
      0,
      0,
      NULL,
      NULL,
      1.755620,
      NULL,
      NULL,
      1,
      0.118994,
      NULL,
      NULL,
      1,
      1.104307,
      NULL,
      0.118876,
      NULL,
      NULL,
      5,
      3.205063,
      NULL,
      0.923067,
      NULL,
      NULL,
      1,
      0.169330,
      0.394813,
      0.934139,
      NULL,
      NULL,
      1.224426,
      0.459253,
      2,
      0,
      6.035139,
      NULL,
      9.768928,
      2.609361,
      NULL,
      NULL,
      8.731808,
      3,
      NULL,
      4.955614,
      1,
      NULL,
      1,
      1.476419,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531856,
      NULL,
      NULL,
      0,
      1,
      1.997635,
      0.652127,
      0.989787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2.526705,
      1,
      1.834260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770511,
      3.218096,
      3,
      1.659155,
      0,
      NULL,
      0,
      1.881137,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494254,
      1.864821,
      3,
      0.637954,
      NULL,
      2,
      1,
      1.300411,
      0,
      1,
      3.736304,
      0.999534,
      1,
      0.921661,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.721843,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


