set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44',
      2,
      4.006576,
      '4034142',
      68.403927,
      NULL,
      0.930063,
      2,
      '112002',
      5.625094,
      ' 9-12-1983',
      2.297759,
      3.806804,
      1.143267,
      NULL,
      1,
      1,
      1.817846,
      1.930921,
      1,
      1,
      1,
      0,
      1,
      1,
      2,
      0.930077,
      4.698729,
      1.934611,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.572417,
      0,
      NULL,
      1,
      4.446496,
      3.326412,
      3.414624,
      0.579221,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.215030,
      1.272047,
      NULL,
      1,
      1.535803,
      1,
      NULL,
      1.242498,
      1,
      1,
      1,
      2,
      1,
      1.880222,
      1.685724,
      NULL,
      NULL,
      2,
      3.514471,
      0.694859,
      1.714551,
      1.268520,
      NULL,
      0,
      0,
      NULL,
      1.765634,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.061790,
      1,
      0.175459,
      3,
      0,
      NULL,
      1.941604,
      1.057787,
      0,
      NULL,
      0.112266,
      NULL,
      3.248096,
      1.852635,
      1.301913,
      NULL,
      1.090754,
      0.061930,
      NULL,
      1.218904,
      2.897990,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      2,
      NULL,
      7.900439,
      NULL,
      1,
      7,
      9.724844,
      NULL,
      1.573937,
      6.047846,
      2,
      8.440696,
      5.801944,
      3.136151,
      1.269441,
      1,
      3.035358,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095525,
      0.452193,
      1,
      1,
      0,
      0.136949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.594674,
      2.682437,
      2.242826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.521198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.810571,
      1.729147,
      2,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.827845,
      1.983150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740408,
      2,
      2,
      2,
      1,
      1.442408,
      0,
      2,
      NULL,
      3.910904,
      1.091886,
      1.164006,
      0,
      1.088147,
      NULL,
      1,
      1,
      0.836209,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '21403',
      '',
      '',
      0.396800,
      '',
      '',
      '',
      1.866079,
      NULL,
      '',
      NULL,
      NULL,
      5,
      0.192615,
      3,
      NULL,
      3,
      1,
      2,
      5.021342);
commit;
end;
/


