set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '24444012',
      NULL,
      18.400854,
      '1040042',
      76.411114,
      5,
      3.265962,
      2,
      '441204',
      2,
      ' 4-10-1986',
      47,
      8.098773,
      1.606960,
      NULL,
      NULL,
      0,
      1.232090,
      1.589277,
      0.325333,
      NULL,
      NULL,
      3,
      0.404663,
      1.841492,
      4.430695,
      0.406833,
      1.570011,
      1,
      NULL,
      0,
      3,
      0.844381,
      NULL,
      NULL,
      0,
      1,
      2.070943,
      1,
      2.200608,
      3,
      3.050054,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.067969,
      0.535379,
      3.469126,
      NULL,
      NULL,
      NULL,
      2.226501,
      NULL,
      3,
      0,
      0.761267,
      NULL,
      3,
      1,
      0,
      1.749378,
      1.368916,
      1,
      1.990813,
      NULL,
      1.421933,
      1,
      4,
      1,
      2,
      0.495580,
      1,
      NULL,
      NULL,
      1.944701,
      NULL,
      NULL,
      0.834478,
      1.575474,
      1,
      1,
      0.918743,
      1,
      1.647378,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0.660296,
      NULL,
      1,
      1.291564,
      NULL,
      1.374952,
      NULL,
      1,
      0,
      1.053947,
      2.562248,
      5,
      1,
      0,
      2.507372,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.200752,
      1,
      1.590112,
      1.395251,
      2,
      8.305498,
      3.937928,
      8,
      NULL,
      5,
      5,
      9,
      3,
      3.873615,
      4,
      1.794385,
      0.444268,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923338,
      1,
      1,
      0,
      1,
      0,
      0.250788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175345,
      1.637141,
      4,
      2,
      1.380299,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.380382,
      NULL,
      1.283746,
      0,
      2.293786,
      2.504958,
      0,
      0,
      3.432155,
      0,
      1,
      1.769998,
      0.870903,
      1,
      0.214534,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.528241,
      '20324',
      '',
      '',
      1.707771,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.280116,
      0.764416,
      1.272402,
      0.571567,
      2,
      NULL,
      3,
      3,
      NULL);
commit;
end;
/


