set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30030410',
      22.003722,
      NULL,
      '1012313',
      14,
      3,
      NULL,
      3,
      NULL,
      5.515776,
      NULL,
      41,
      49.601729,
      1,
      NULL,
      0,
      1,
      2,
      1.769909,
      1,
      0,
      0.695658,
      0.149718,
      1.978130,
      0.712287,
      NULL,
      0,
      3.713396,
      NULL,
      NULL,
      0.656911,
      6.989343,
      1.581919,
      1.465321,
      0,
      2.143059,
      1,
      6,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.161979,
      NULL,
      NULL,
      0.691589,
      3.140663,
      0,
      NULL,
      2,
      0,
      NULL,
      1.260776,
      0.859481,
      0,
      2,
      NULL,
      1.908964,
      NULL,
      0,
      0.369245,
      1,
      1,
      0,
      1,
      0.513910,
      0.723985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788647,
      1.459451,
      0,
      0,
      0,
      1,
      1.932263,
      1.576105,
      NULL,
      1,
      0.671848,
      1.235251,
      NULL,
      0.103812,
      0,
      0,
      NULL,
      NULL,
      0.167159,
      NULL,
      1,
      2,
      0.102622,
      1.941357,
      2,
      1.489288,
      0.840650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.706616,
      NULL,
      NULL,
      NULL,
      0.218319,
      0,
      5,
      5,
      5,
      NULL,
      1.786624,
      2.289768,
      4,
      2,
      0,
      NULL,
      NULL,
      1.968388,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903405,
      0,
      0,
      0.478282,
      1,
      1.992027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.983514,
      1,
      3.933827,
      1.917028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.431111,
      0,
      3,
      2,
      0.604948,
      0.701911,
      NULL,
      4,
      2.277563,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1,
      2.464514,
      2,
      3.303711,
      1.817714,
      NULL,
      2.952243,
      0.670812,
      NULL,
      1,
      1,
      0.399568,
      0.200027,
      0,
      0.032765,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.096485,
      '43203',
      '',
      '',
      1.047571,
      '',
      '',
      NULL,
      1.294401,
      '',
      '',
      '',
      4.302203,
      4,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      3);
commit;
end;
/


