set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '02314004',
      14.743491,
      41.140846,
      '0211101',
      NULL,
      6,
      2,
      1,
      '323041',
      0,
      ' 9-21-1980',
      50,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.327278,
      1.604573,
      0,
      0.255739,
      1,
      0.101693,
      1.889227,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      1,
      1.242948,
      1,
      0.495840,
      0,
      7,
      NULL,
      3.032325,
      0,
      2,
      2,
      0.866942,
      1,
      NULL,
      NULL,
      0.062014,
      NULL,
      NULL,
      6.003861,
      NULL,
      1.323913,
      0.816539,
      0.119523,
      NULL,
      1.492048,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.832816,
      1,
      1,
      1.954688,
      2,
      0,
      0.588470,
      1.873134,
      0,
      2,
      1,
      1,
      NULL,
      1.272411,
      NULL,
      NULL,
      1.882691,
      NULL,
      NULL,
      0,
      1.389987,
      0,
      1.780868,
      0.093703,
      NULL,
      0.543439,
      0,
      1.146735,
      0,
      1.527419,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.989807,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.034383,
      0,
      0.376827,
      0.749050,
      NULL,
      NULL,
      NULL,
      NULL,
      3.145111,
      2.486467,
      1.583325,
      0.939444,
      0.883051,
      7.889069,
      7,
      4,
      3,
      3,
      NULL,
      5.309642,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      0,
      2.709584,
      0.341869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.149490,
      NULL,
      1,
      NULL,
      1.706963,
      0.222861,
      1.207924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.369115,
      3,
      2.560389,
      0.622603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.873587,
      2.133501,
      0,
      NULL,
      NULL,
      NULL,
      0.375651,
      0,
      1.299575,
      7,
      2,
      1,
      1.095762,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.597109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.085584,
      0.452870,
      NULL,
      2,
      3,
      1,
      0,
      3,
      1.853304,
      1.885273,
      1,
      NULL,
      NULL,
      NULL,
      0.549155,
      NULL,
      0,
      0.247871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '42234',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.233181,
      '',
      '',
      NULL,
      1.542171,
      2.830926,
      NULL,
      2.475426,
      1,
      2.850565,
      NULL,
      1,
      0);
commit;
end;
/


