set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      NULL,
      36,
      NULL,
      '3420224',
      15,
      5,
      3,
      2,
      '103242',
      3,
      ' 8-15-1989',
      55.268034,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.865930,
      NULL,
      NULL,
      1.059102,
      0.885683,
      0,
      0,
      1.699361,
      4,
      1.767122,
      0.855610,
      1.763744,
      1.381968,
      NULL,
      1,
      NULL,
      0.314246,
      1,
      1.417503,
      0,
      7.023292,
      NULL,
      5.002941,
      2,
      NULL,
      1.062606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.225972,
      0.373196,
      1,
      0.017273,
      1,
      NULL,
      0,
      2,
      1,
      2.774064,
      0,
      NULL,
      NULL,
      1,
      3.669380,
      0,
      3.122468,
      0,
      0,
      1.946689,
      0.985249,
      9,
      1,
      2,
      2.306219,
      NULL,
      NULL,
      NULL,
      0.200454,
      NULL,
      NULL,
      0,
      0,
      0.633326,
      0.403292,
      1.344401,
      NULL,
      1,
      1,
      1.920193,
      0,
      0,
      NULL,
      NULL,
      1,
      0.795442,
      0,
      NULL,
      1,
      1.498047,
      NULL,
      NULL,
      1,
      1.770460,
      NULL,
      0,
      0,
      1,
      0.564188,
      NULL,
      NULL,
      NULL,
      NULL,
      2.897282,
      5,
      NULL,
      0,
      NULL,
      3.056971,
      8.326770,
      6,
      NULL,
      3.045070,
      7.467466,
      NULL,
      4.190958,
      NULL,
      5,
      3,
      1,
      1,
      0,
      2.962373,
      0.583721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274601,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966618,
      0,
      NULL,
      4.962334,
      1,
      1.889103,
      NULL,
      NULL,
      NULL,
      1.705323,
      1,
      0.322123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881200,
      2.366791,
      3.884748,
      1,
      NULL,
      0,
      0.411745,
      3.274059,
      NULL,
      3.112436,
      0.034183,
      0,
      1,
      1,
      0,
      1.491542,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '22434',
      '',
      NULL,
      0.386811,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      2.437701,
      3,
      1.674432,
      1.923734,
      1,
      1.336775,
      1,
      3.177427);
commit;
end;
/


