set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '41031302',
      12,
      NULL,
      '0031012',
      138,
      0,
      NULL,
      2,
      NULL,
      1.353039,
      ' 3-29-1992',
      41.453864,
      45.665869,
      0.156330,
      NULL,
      0,
      0,
      0.843191,
      1,
      1,
      0.628881,
      1,
      1,
      0.580429,
      1,
      NULL,
      NULL,
      0,
      0.204177,
      1,
      0.075922,
      6.148414,
      NULL,
      1.949857,
      1.731510,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.718858,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      1,
      1,
      1,
      1,
      2.788347,
      1.951142,
      3.388211,
      0.292527,
      2.260572,
      3,
      NULL,
      0.793530,
      0.778274,
      2,
      NULL,
      0.630025,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626379,
      1.312627,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.446122,
      NULL,
      0,
      1.428001,
      1,
      1.106146,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      NULL,
      2.131183,
      NULL,
      NULL,
      0,
      1.427891,
      NULL,
      NULL,
      NULL,
      NULL,
      5.142828,
      NULL,
      1.670488,
      1.299964,
      0.375366,
      4,
      2.353325,
      1.043298,
      2.440412,
      5.259375,
      9,
      3,
      8.433554,
      NULL,
      2,
      2.984623,
      3,
      0.060121,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911008,
      1.420469,
      NULL,
      1,
      0,
      1.688740,
      0.791952,
      0.926674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.995994,
      NULL,
      3.115236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.284659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538651,
      1,
      5,
      1.522608,
      2,
      1.358180,
      NULL,
      NULL,
      NULL,
      1,
      0.797553,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315623,
      3,
      3.699812,
      2.764246,
      3.853140,
      1,
      1.457980,
      2,
      0.253764,
      2.472772,
      0.649515,
      1.742011,
      NULL,
      1.919547,
      0,
      0,
      0.013031,
      0,
      NULL,
      0.983712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.079884,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      0,
      2.389200,
      1,
      2.876421,
      NULL,
      2,
      NULL,
      4.239693);
commit;
end;
/


