set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      NULL,
      9.421296,
      54.441554,
      '0004031',
      75.284050,
      NULL,
      3,
      2,
      '303104',
      NULL,
      '11-29-1993',
      1.826882,
      9.450758,
      1,
      NULL,
      NULL,
      1.508144,
      3,
      NULL,
      1,
      1.126446,
      1,
      0,
      NULL,
      0.176371,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.064747,
      1,
      1,
      0,
      4.615831,
      0.706677,
      3,
      0,
      3,
      3,
      1,
      0.665112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.971572,
      0,
      8.412113,
      3,
      1.465624,
      NULL,
      3.434816,
      3.428005,
      0,
      1,
      NULL,
      1,
      0.150294,
      2,
      0.710594,
      NULL,
      1.439370,
      0.365578,
      0,
      1,
      1.280143,
      1.203206,
      4,
      1,
      NULL,
      2.647562,
      1.594412,
      NULL,
      NULL,
      0.813822,
      NULL,
      NULL,
      0,
      1.079599,
      0,
      1.521140,
      0.668808,
      1.306446,
      5.440509,
      1,
      1.218595,
      0.573998,
      1.237372,
      1.087300,
      0.307083,
      2.737772,
      0,
      1.120361,
      0,
      1.933907,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.098501,
      NULL,
      0.095652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.023261,
      1.390641,
      NULL,
      1.951927,
      0,
      4.500773,
      7.227194,
      6.596621,
      NULL,
      0,
      9.653612,
      3,
      2.839671,
      2,
      2,
      1,
      1.612944,
      1.083925,
      1.810424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987388,
      0.377731,
      NULL,
      NULL,
      1.686029,
      0,
      NULL,
      0.869762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.073197,
      0.373069,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      1.662561,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0.539013,
      3.636223,
      2.236546,
      NULL,
      3,
      0,
      3,
      0.450022,
      NULL,
      1.831064,
      0.708979,
      1.027246,
      1,
      0.262940,
      0.103233,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '12140',
      '',
      '',
      0.353500,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      4.892949,
      0.167723,
      0,
      5,
      1.979207,
      1,
      1,
      3,
      NULL);
commit;
end;
/


