set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '00224240',
      NULL,
      NULL,
      '4332401',
      46.041803,
      3,
      1.884183,
      3,
      '131103',
      3,
      ' 4- 7-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.979554,
      0,
      1.170555,
      0,
      0.060346,
      2,
      1,
      NULL,
      NULL,
      0.207369,
      0,
      1,
      NULL,
      0,
      3.463094,
      0,
      NULL,
      2.736132,
      3,
      1,
      NULL,
      0,
      4,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.979205,
      4,
      5,
      2,
      1,
      1,
      1,
      2.720690,
      2.331678,
      NULL,
      1,
      0,
      1.015679,
      2.815862,
      1,
      3.943949,
      0.027000,
      1,
      1,
      1.970755,
      0,
      1.556668,
      4,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.440857,
      1.034166,
      1,
      0.081644,
      0,
      3,
      0,
      NULL,
      0,
      2,
      2.038827,
      1,
      4.578531,
      1.769009,
      1.943046,
      1.445240,
      0,
      0,
      NULL,
      0,
      2,
      0.264855,
      2.713169,
      0.830213,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024131,
      NULL,
      0.995718,
      1.108334,
      0,
      NULL,
      NULL,
      5.973702,
      5,
      8,
      NULL,
      NULL,
      5.557608,
      1,
      5,
      2.657509,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.588999,
      0,
      1.875800,
      0.614501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.144617,
      NULL,
      7,
      2,
      2,
      0.809880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.500801,
      3.738869,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.585586,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.234679,
      2.788600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947407,
      NULL,
      3,
      1.654475,
      3.826493,
      NULL,
      0.833240,
      NULL,
      1.309343,
      NULL,
      3,
      NULL,
      1.349707,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '21103',
      '',
      '',
      0.910770,
      NULL,
      '',
      '',
      0.113173,
      '',
      '',
      '',
      1,
      2,
      1,
      3,
      0.813062,
      NULL,
      0,
      3,
      1.054990);
commit;
end;
/


