set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4210',
      '21414440',
      43,
      38,
      NULL,
      70,
      4,
      NULL,
      NULL,
      '324034',
      0.147862,
      ' 2-27-2002',
      19.383691,
      16.205402,
      NULL,
      NULL,
      0,
      0.679319,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1.322588,
      NULL,
      0,
      2.892703,
      1,
      0.270459,
      NULL,
      2.100793,
      0,
      NULL,
      1,
      0.157969,
      0.045572,
      3.093364,
      NULL,
      NULL,
      2.590894,
      3.627390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      6.197822,
      7.691617,
      NULL,
      0,
      1.988090,
      1,
      0,
      0,
      2,
      1.927594,
      1.063686,
      NULL,
      3.878131,
      0,
      1,
      0,
      1.369559,
      2.891702,
      0.962615,
      0,
      0,
      9.309970,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      2.638710,
      NULL,
      0,
      0,
      1,
      1,
      0,
      5,
      0,
      1.605590,
      1,
      1,
      NULL,
      NULL,
      0.297906,
      4.129326,
      NULL,
      0,
      0,
      0.163418,
      3.363798,
      3.171508,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.248979,
      1,
      NULL,
      NULL,
      9.101075,
      3.572544,
      3.087065,
      NULL,
      7,
      3.463630,
      NULL,
      1,
      0.741982,
      0.641840,
      0,
      1.370704,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215987,
      1.672162,
      1,
      0,
      1.732738,
      0.319893,
      0.909893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.480249,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.112114,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136113,
      2,
      0.000970,
      2.807348,
      1,
      2.774628,
      0.777759,
      3.110365,
      0.980111,
      0.150466,
      1.196248,
      0,
      0.040077,
      1,
      0,
      0.635709,
      0.675777,
      0.723335,
      1.498502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      0.884617,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      5,
      3.651070,
      4.885369,
      2,
      3.532654,
      2.332986,
      NULL,
      3);
commit;
end;
/


