set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24311222',
      9,
      NULL,
      '2332221',
      75.050573,
      5,
      1.747332,
      2,
      NULL,
      2.832250,
      '10- 1-1988',
      NULL,
      6.684221,
      0,
      NULL,
      0.644023,
      0,
      3,
      1,
      0,
      1,
      0.227581,
      0.915589,
      0,
      1.896019,
      1.934003,
      0,
      1.795234,
      1.537513,
      0.945523,
      1,
      2,
      NULL,
      0,
      0.516918,
      7,
      1.048721,
      0.215378,
      0,
      0.076726,
      3.087112,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.341160,
      NULL,
      0.104871,
      1,
      3.528606,
      2.335524,
      3.633159,
      1.920838,
      3,
      0,
      3.817561,
      2.284683,
      0,
      1,
      NULL,
      NULL,
      2.393640,
      1,
      NULL,
      0,
      7,
      0,
      NULL,
      1.876212,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.223953,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.204749,
      NULL,
      NULL,
      1,
      NULL,
      0.683443,
      NULL,
      0,
      0,
      NULL,
      0.621123,
      NULL,
      0.545664,
      1.625868,
      2.784516,
      0,
      NULL,
      1.787377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095338,
      NULL,
      1,
      4,
      0.206453,
      2.722944,
      7.394429,
      8.723949,
      9,
      5,
      8,
      9.097949,
      1.345995,
      3.845922,
      2,
      1.060032,
      1.522908,
      0,
      NULL,
      0.823362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481510,
      1.829702,
      NULL,
      1,
      NULL,
      0,
      0.519343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920817,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4.188114,
      0,
      5,
      3.388766,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957429,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608377,
      NULL,
      NULL,
      2,
      NULL,
      3.434930,
      1,
      3,
      1.883377,
      3.385876,
      3.477879,
      0.735548,
      NULL,
      NULL,
      0,
      0,
      0.205003,
      0.791792,
      0.198864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0.604065,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      2,
      0.282722,
      3,
      NULL,
      3.263580,
      0.569450,
      NULL,
      1.880255);
commit;
end;
/


