set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1034',
      '10141221',
      37.391545,
      49.000207,
      '1110332',
      39,
      1,
      1,
      2,
      '322421',
      0,
      ' 9- 7-2002',
      64,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      0.851453,
      0.046039,
      2.007957,
      0.174141,
      NULL,
      6,
      0,
      NULL,
      1.533709,
      0,
      0,
      6,
      0,
      2.760561,
      3,
      NULL,
      0.211562,
      5,
      1,
      NULL,
      2,
      3,
      0.941838,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      2,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      3,
      1.545262,
      0.528884,
      1.088893,
      0.214337,
      NULL,
      0,
      3.685699,
      0.825635,
      3.794462,
      1,
      1.058869,
      0.968187,
      1,
      8.371164,
      0,
      2,
      NULL,
      0.021855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324735,
      1,
      1.041989,
      1,
      0,
      4,
      2,
      0.933283,
      0.195077,
      0,
      1,
      0,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.683354,
      0,
      1.035656,
      3,
      1.995093,
      NULL,
      4.843584,
      0,
      5,
      0,
      1.216256,
      1,
      5.051847,
      0,
      3.182384,
      3.489924,
      6,
      0,
      1,
      2.547135,
      1,
      NULL,
      7,
      NULL,
      7.317723,
      1.533169,
      3,
      3.601787,
      2.698141,
      NULL,
      NULL,
      0,
      0.814289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084769,
      0,
      1,
      1,
      0.745231,
      0,
      0.331462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.713225,
      NULL,
      3,
      2.544352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.175909,
      1.468161,
      NULL,
      2,
      0.764683,
      NULL,
      NULL,
      NULL,
      0,
      3.730777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.501759,
      2,
      2,
      2,
      1.407676,
      1.790757,
      0.653037,
      0.063133,
      3.094835,
      3.088067,
      NULL,
      NULL,
      0.418775,
      1,
      0.010752,
      1,
      0.523583,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44023',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      2,
      1.692211,
      NULL,
      2,
      2.757827,
      0,
      NULL,
      5);
commit;
end;
/


